//__________________________________________________________________________________________________

half4 HDRToLDR( half4 colour, bool UseAlphaChannel )
{
	half Exposure			= exposure.x;
	half ExposureDivRange	= exposure.y;
	half InvRange			= exposure.z;
	half Threshold			= exposure.w;

	#if defined(HDR_ALPHACHANNELEXPONENT)
		// Apply exposure
		colour.rgb *= Exposure;

		// Calculate 'intensity' above threshold
		half maxComponent = max( max( colour.r, colour.g ), colour.b );
		half HDRFactor = (maxComponent - HDRThreshold) * InvRange;

		#if defined(HDR_PRESERVESATURATION)
			// Keep saturated colour
			if (HDRFactor > 0.0)
			{
				colour.rgb /= maxComponent;
			}
		#endif
		
		// Set HDR factor in alpha channel (only works for non alpha'd geometry!)
		colour.a = HDRFactor;
	#else
		// Apply exposure as well as scaling by 'range', using standard RGB colour to encode
		// greater range by sacrificing accuracy
		colour.rgb *= ExposureDivRange;
		
		#if defined(HDR_PRESERVESATURATION)
			// Keep saturated colour
			half maxComponent = max( max( colour.r, colour.g ), colour.b );
			if (maxComponent > 1.0)
			{
				colour.rgb /= maxComponent;
			}
		#endif
	#endif

	return colour;
}

//__________________________________________________________________________________________________

half4 LDRToHDR( half4 colour, bool UseAlphaChannel )
{
	half Exposure			= exposure.x;
	half ExposureDivRange	= exposure.y;
	half InvRange			= exposure.z;

#if defined(UBERSHADER) && PIXEL_SHADER_VERSION <= 14
	half RangeDivExposure	= exposure.w;
#else
	half Threshold			= exposure.w;
#endif

	#if defined(HDR_ALPHACHANNELEXPONENT)

		half Range = 1.0f / InvRange;
		half ThresholdPlusOne = HDRThreshold + 1.0;

		// Recontruct range from alpha
		colour.rgb *= colour.a * (ThresholdPlusOne*Range);

		// Remove camera exposure and restore range
		colour.rgb /= ExposureDivRange;

		// Clear alpha
		colour.a = 1.0;
	#else
		// Remove camera exposure and restore range
		#if defined(UBERSHADER) && PIXEL_SHADER_VERSION <= 14
			colour.rgb *= RangeDivExposure;
		#else
			colour.rgb /= ExposureDivRange;
		#endif
		
	#endif

	return colour;
}